﻿/*
VERSION:	1.5
	1.5		No longer sends an error if a new load starts before the old load finishes  (an error interruption will prevent the new load's success from being detected)
	1.4		Calls map.onError() when map3 reports errors  (map.as doesn't report errors)
	1.3		Fixed useCache parameter
	1.2		onLoad() passes mapData through to listening external code
	1.1		The old map system is #included using its original filename of "map.as" instead of "map2.as"
	
USAGE:
	var makeMap;
	#include "functions/map_formats.as"
	map_mc = makeMap();
	map_mc.drawObj( myMapData );
	
DEPENDENCIES:
	addCollisionMethods.as
	copyObject.as
	nextDepth.as
	readXml.as
	VOW.as
	VOW/loadBitmap.as
*/
#include "addCollisionMethods.as"
function makeMap2(){
	#include "map.as"
	var doMakeMap = makeMap;		// preserve in local scope
	delete _this.makeMap;			// remove from outer movieClip scope
	return doMakeMap.apply( _this, arguments );
}// makeMap2()
function makeMap3(){
	#include "map3.as"
	var doMakeMap = makeMap;		// preserve in local scope
	delete _this.makeMap;			// remove from outer movieClip scope
	var map_mc = doMakeMap.apply( _this, arguments );
	
	var currentData = null;
	map_mc.drawObj = function( data, useCache ){
		if(useCache==undefined)		var useCache=true;		// use chipset cache unless told not to
		if( map_mc.isCompressed(data) ){
			var data = map_mc.decompressMapData(data);
		}// if:  data is compressed
		currentData = data;
		
		map_mc.drawMap( data, useCache )
		.then( drawDone, error );
		
		function drawDone(){
			if( data !== currentData )		return;		// don't announce success if another load started
			// add legacy properties
			map_mc.collision_array = data.collision;		// using uncompressed data
			map_mc.width = data.width;
			map_mc.height = data.height;
			map_mc.tileSize = data.tileSize;
			addCollisionMethods( map_mc.collision_array );		// WARNING:  Potential data-leak if external code references these functions directly
			map_mc.onLoad( data );
		}// drawDone()
		
		function error( err_obj ){
			// don't fail if another load started in the meantime,  because external code will think the most recent load failed if we announce an error now
			if( data !== currentData )		return;
			
			map_mc.onError( err_obj );
		}// error()
		
	}// drawObj()
	return map_mc;
}// makeMap3()
if(levelData.map.format == 3){
	makeMap = makeMap3;
}else{
	makeMap = makeMap2;
}